/* Normalized hide address bar for iOS & Android (c) Scott Jehl, scottjehl.com MIT License */
(function(a){var b=a.document;if(!location.hash&&a.addEventListener){window.scrollTo(0,1);var c=1,d=function(){return a.pageYOffset||b.compatMode==="CSS1Compat"&&b.documentElement.scrollTop||b.body.scrollTop||0},e=setInterval(function(){if(b.body){clearInterval(e);c=d();a.scrollTo(0,c===1?0:1)}},15);a.addEventListener("load",function(){setTimeout(function(){if(d()<20){a.scrollTo(0,c===1?0:1)}},0)})}})(this);

/*! A fix for the iOS orientationchange zoom bug. Script by @scottjehl, rebound by @wilto.MIT License.*/
(function(m){var l=m.document;if(!l.querySelector){return}var n=l.querySelector("meta[name=viewport]"),a=n&&n.getAttribute("content"),k=a+",maximum-scale=1",d=a+",maximum-scale=10",g=true,j,i,h,c;if(!n){return}function f(){n.setAttribute("content",d);g=true}function b(){n.setAttribute("content",k);g=false}function e(o){c=o.accelerationIncludingGravity;j=Math.abs(c.x);i=Math.abs(c.y);h=Math.abs(c.z);if(!m.orientation&&(j>7||((h>6&&i<8||h<8&&i>6)&&j>5))){if(g){b()}}else{if(!g){f()}}}m.addEventListener("orientationchange",f,false);m.addEventListener("devicemotion",e,false)})(this); 

(function(w){
	var sw = document.body.clientWidth,
		sh = document.body.clientHeight,
		breakpoint = 650,
		speed = 800,
		mobile = true;
		
	$(document).ready(function() {
		checkMobile();
		setNav();
		setImg();
	});
		
	$(w).resize(function(){ 
		sw = document.body.clientWidth;
		sh = document.body.clientHeight;
		checkMobile();
	});
	
	// verifie si le terminal est mobile
	function checkMobile() {
		mobile = (sw > breakpoint) ? false : true;
		if (!mobile) { // non mobile
			loadAux();
			$('.aux header a').addClass('disabled').addClass('open');
			$('[role="tabpanel"],#nav,#search').show();
		} else { 
			if(!$('#nav-anchors a').hasClass('active')) {
				$('#nav,#search').hide();
			}
		}
	}
	
	// Gestion menu a 2 niveaux
	function setNav() {
		var $anchorLinks = $('#nav-anchors').find('a');
		$anchorLinks.click(function(e){
			e.preventDefault();
			var $this = $(this),
				thisHref = $this.attr('href');
			$('.reveal').hide();
			if($this.hasClass('active')) {
				$this.removeClass('active');
				$(thisHref).hide();
			} else {
				$anchorLinks.removeClass('active');
				$this.addClass('active');
				$(thisHref).show();
			}
		});
	}
	
	// Carrousel d'images pour mobiles
	function setImg() {
		var container = $('#img-container'),
			nav = $('#app-img').find('nav'),
			imgList = Object,
			current = 0,
			swipeEnabled = false;
		
		function buildGallery() {
			container.html('<div id="img-list"><ul /></div>');
			imgList = $('#img-list');
			nav.find('li:first').addClass('active');
			
			var arr = '';

			nav.find('a').each(function() {
				var $this = $(this),
					href = $this.attr('href');
				arr += '<li data-imgsrc="'+href+'"></li>';
			});
			
			imgList.find('ul').append(arr);
			
			// clic sur les miniatures
			nav.on('click','a',function(e) {
				var pos = $(this).parent().index();
				e.preventDefault();
				loadImg(pos);
				if(swipeEnabled) {
					mySwipe.slide(pos,300);
				}
				updateNav(pos);
			});
			
			Modernizr.load({
			  test: Modernizr.touch && Modernizr.csstransitions,
			  yep : 'js/swipe.js',
			  complete : function() {
					if(w.Swipe) {
						swipeEnabled = true;
						buildSwipe();
					}
			  }
			});
			loadImg(0); // chargement de la copie d'cran initiale
		}
		
		// swipe carousel
		function buildSwipe() {
			// init Swipe.js
			var imgList = document.getElementById('img-list');
			w.mySwipe = new Swipe(imgList, {
				callback: function(event, index, elem) {
					updateNav(index);
					loadImg(index+1);
				}	
			});
			imgList.addEventListener('touchstart', function(event) {
    			loadImg(w.mySwipe.getPos()+1);
			}, false);
		}
		
		// chargement dynamique des images
		function loadImg(index) {
			var lis = imgList.find('li'),
				li = lis.eq(index),
				imgSrc = li.attr('data-imgsrc');
			if(!swipeEnabled) {
				lis.hide();
				li.show();
			}
			
			if(li.html() === "") { // liste vide
				var img = new Image();
				imgList.addClass('loading');
				$(img).load(function () { // chargement image
					$(this).hide();
					li.removeClass('loading');
					$(this).fadeIn();
				}).error(function () {
					// notification erreur au chargement image pour l'utilisateur
				}).attr('src', imgSrc);
				$('<img />').attr('src',imgSrc).appendTo(li);
			}
		}
		
		function updateNav(pos) {
			nav.find('li').removeClass('active');
			nav.find('li:eq('+pos+')').addClass('active');
		}
		
		buildGallery();
	}
	
	$('.aux header a').addClass('disabled');
	
	function loadAux() {
		var $aux = $('.aux');
		$aux.each(function(index) {
			var $this = $(this),
				auxLink = $this.find('a'), 
				auxFragment = auxLink.attr('href'),
				auxContent = $this.find('[role=tabpanel]');
			if(auxContent.size()===0 && $this.hasClass('loaded')===false){
				loadContent(auxFragment,$this);
			}
		});
	}
	
	function loadContent(src,container) { // chargement contenus dynamiques
		container.addClass('loaded');
		$('<div role="tabpanel" />').load(src +' #content > div',function() {
			$(this).appendTo(container);
		});
	}
	
	$('.aux header a').click(function() {
		var $this = $(this),
			thisHref = $this.attr('href'),
			tabParent = $(this).parents('section'),
			tabPanel = tabParent.find('[role=tabpanel]');
		if(mobile) { 
			if(tabPanel.size()===0) {
				loadContent(thisHref,tabParent);
				$this.addClass('open');
			} else { //Toggle 
				tabPanel.toggle();
				$this.toggleClass('open');
			}
		} 
		return false;
	});
	
})(this);